<!-- Copyright (c) 2004, 2006-2007 by Cisco Systems, Inc. -->
// Parsing code for 3750, 2970, 3560

/* 
 * Used to determine the software upgrade stages. Stages will be 
 * displayed below the 'instructions' table. Appropriate error message   
 * will be displayed if there is any error message. 
 */
var contents = "";
var isff1_5 = (navigator.appName.indexOf("tscape") !=-1) ? true : false;

function getStreamedOutput()
{
//	var str 	= "";
	str 		= parent.result.document.body.innerHTML;			// Get the result frame content.
	contents	= parent.result.document.body.innerHTML;		
	//extract the text without <pre> </pre> tags in IE alone
	if ( isff1_5 )
		currContent = str;				
	else
		currContent = str.substring(5,str.length-6);
	if(currContent.indexOf("BODY") != -1)
		currContent = "";
		
	diff		= getDifference(prevContent, currContent);  		// Get the difference (or) Get the new output. 
	// if there is no content. Make it as loading stage.
	if(currContent.length == 0 || currContent.indexOf("BODY") != -1)		// For nn7
	{
		currStage = 1;												// Still Loading stage.
		prevStage = 1;
		//displayStage(currStage);					
	}
	
	if(isStackable && currStage == 3) { //display a generated progress bar
		size  = 50000;							// Get the total file size extracted.
		var date = new Date();
		var currTime = date.getTime();
		currPercentage = (totalExtractedBytes/totalSize) * 100;
		currPercentage = Math.round(currPercentage);
		var elapsedTime = currTime - startTime;
		
		if(currPercentage > 0) {
			timerInterval = (elapsedTime / currPercentage);
			timerInterval = Math.round(timerInterval);
		}

		totalExtractedBytes  += size;
		currPercentage = (totalExtractedBytes/totalSize) * 100;
		currPercentage = Math.round(currPercentage);
		if(currPercentage >= 80)		
				currPercentage = 80;
		if(currPercentage > prevPercentage)	{
			startProgress(prevPercentage, currPercentage, timerInterval);	// Show the progress bar.
		}	
		prevPercentage = currPercentage; 
	}
	
	if(diff.length != 0) // New updated content has come from the device.
	{
		currStage	  = getStage(diff);								// Get the stage.
		if(currStage == 2 && totalSize == 0)						// If it is loading stage, parse the total file size.	
		{
			startInd = diff.indexOf("Total Image File Size:"); 
			if(startInd != -1)
			{
                        //workaround added since \n character is not seen in firefox1.5
                        if ( isff1_5)
                                stopInd = startIndex+33;
                        else
                                stopInd = diff.indexOf("\n",startIndex );

				tot_size = diff.substring(startInd+22,stopInd);		// Parsing the total file size.				
				totalSize = parseInt(tot_size,16);					// Store total file size.	
//				totalSize = totalSize * top.getDeviceList().length;					
				totalSize = totalSize * totalDevices;	
			}
		}
				
		if(currStage != prevStage)									// If there is any change of stage, activate the stage.
		{
			displayStage(currStage);			
		}
		
		if(!isStackable && currStage == 3)							// For extracting stage, show the progress bar.
		{	
			size  = getTotalFileSize(diff);							// Get the total file size extracted.
			var date = new Date();
			var currTime = date.getTime();
			currPercentage = (totalExtractedBytes/totalSize) * 100;
			currPercentage = Math.round(currPercentage);
			var elapsedTime = currTime - startTime;
			if(currPercentage > 0) {
				timerInterval = (elapsedTime / currPercentage);
				timerInterval = Math.round(timerInterval);
			}

			totalExtractedBytes  += size;
			currPercentage = (totalExtractedBytes/totalSize) * 100;
			currPercentage = Math.round(currPercentage);
			if(currPercentage >= 100)		
					currPercentage = 100;
			if(currPercentage > prevPercentage)	
			{			
			//window.status = "Devices : " + totalDevices + " , Pre % : " + prevPercentage + " , curr % : " + currPercentage + " , Timer : " + timerInterval;
				startProgress(prevPercentage, currPercentage, timerInterval);	// Show the progress bar.
			}	
			prevPercentage = currPercentage; 
		}
		
		//  If it is reloading state, stop polling and activate the checkReload function after 1 min.
		else if (currStage == 4 )    					 			
		{
			isReloadMsgArrived = true;
			startProgress(currPercentage,100, timerInterval);									// Complete the progress
		}
		
		if(anyErrorHappened(diff))									// Check for Any errors.
		{
			stopPolling();
			isUpgrading = false;
			enableMenu();
			errMsg = getErrorMessage(diff);							// Get the corresponding error message.
			if(currStage == 1)
				unHighlight("load", re_swUpg_Txt_Stage1, true);			
			else if(currStage == 2)
				unHighlight("verify", re_swUpg_Txt_Stage2, true);
			else if(currStage == 3)
			{
				set_layercontent("extractDivSymbol","&nbsp;");
				set_layercontent("extractDivStage", "<span class=content>" + re_swUpg_Txt_Stage3 + "</span>");					
				stopProgress();
//				document.getElementById("progressBarDiv").style.border = "0px";
				document.getElementById("progressBarDiv").style.display = 'none';
				document.getElementById("progressBarDiv_ok").style.display = 'none';
				document.getElementById("progressBarDiv_err").style.display = 'block';
			}
			if(isMixedStack && numberOfUpgrades == 1) {
				errMsg = errMsg + "<br>" + re_swUpg_Txt_PartialUpgrade;
			}
			showMsgBottomTable(errMsg,"contentred");								// Show the error message.			
			return;
		}
		prevStage = currStage;
	}	
	prevContent	 = currContent;
	if(currStage == 4 && !isUpgradeOver && numberOfUpgrades > 0)
		notifyFrameLoadStatus("secondUpgrade", "true");
	else
  		id = setTimeout("getStreamedOutput()",2000);		
}


/* 
 * Used to get the current stage. Stages are represented using
 * numbers. Reloading=4;Extracting=3;verifying=2;loading=1;
 */
function getStage(diff)
{
	var state = -1;
	if(diff.indexOf("reload in progress") != -1)								// Search for Reload stage string.		
	{
		state = 4;
	}	
	else if(diff.indexOf("All software images installed") != -1)
	{
		state = 4;
		numberOfUpgrades--;
		if(numberOfUpgrades < 1)
			isUpgradeOver = true;
	}
	else if(isStackable && (diff.indexOf("will be removed after download") != -1 || diff.indexOf("will be removed before download") != -1 || diff.indexOf("will be deleted after download") != -1 || diff.indexOf("will be deleted before download") != -1)) {
		state = 3;			
		setStartTime();
	}
	else if(diff.indexOf("examining image") != -1 || diff.indexOf("Total Image File Size:") != -1)
	{
		state = 2;
		
		startIndex = diff.indexOf("Total Image File Size:"); 
		if(startIndex != -1)
		{
			//workaround added since \n character is not seen in firefox1.5
			if ( isff1_5)
				stopInd = startIndex+33;
			else
				stopInd = diff.indexOf("\n",startIndex );
			tot_size = diff.substring(startIndex+22,stopInd);
			totalSize = parseInt(tot_size,16);
			totalSize *= totalDevices;
		}
		
		if(diff.indexOf("Extracting images from archive") != -1)				// Check for intersection of two stages.
		{
			state = 3;			
			setStartTime();
		}
	}
	else if(diff.indexOf("Extracting images from archive") != -1)
	{
		state = 3;
		setStartTime();
	}
	if(state == -1)				
		state = currStage;		
	return state;
}
